#include <struct.h>
#include <ZMUserAddons/z3dHierarchy.h>
#include "LinkedList.h"

//------------------------------------------------------------------
//
DWORD FAR _stdcall AddRelation(
            sRequestType RT,
            tObjectSet* objects,
            char* DefaultString,
            char* param1,
            char* param2)
{
  lpNamedRef ref = NULL;
//  char str[128];
//  sprintf(str, "adding relation between %s and %s", param1 ? param1: "[]" , param2 ? param2: "[]");
//  AfxMessageBox(str);
  if (FindParent(g_pHList, param1, &ref))
  {
    if ((!ref->pParent && !param2) ||
        (ref->pParent && param2 &&
        !strcmp(ref->pParent, param2)))
      return 0;//ok, already linked
    DeleteRef(g_pHList, ref);
  }
  AddFirst(g_pHList, param2, param1);
  return 0;
}


DWORD FAR _stdcall RemoveRelation(
            sRequestType RT,
            tObjectSet* objects,
            char* DefaultString,
            char* param1,
            char* param2)
{
  DeleteNode(g_pHList, param2, param1);
  return 0;
}


DWORD FAR _stdcall GetNextChild(
            sRequestType RT,
            tObjectSet* objects,
            char* DefaultString,
            char** param1,
            char* param2)
{
  lpNamedRef ref = NULL;
  if (FindNextChild(g_pHList, param2, *param1, &ref))
  {
    if (*param1)
      free(*param1);
    (*param1) = strdup(ref->pChild);
    return 0;
  }
  (*param1) = NULL;
  return 1;
}


DWORD FAR _stdcall _GetParent(
            sRequestType RT,
            tObjectSet* objects,
            char* DefaultString,
            char* param1,
            char** param2)
{
  lpNamedRef ref = NULL;
  if (FindParent(g_pHList, param1, &ref))
  {
    if (*param2)
      free(*param2);
    (*param2) = ref->pParent ? strdup(ref->pParent) : NULL;
    return 0;
  }
  (*param2) = NULL;
  return 1;
}


DWORD FAR _stdcall _HasChild(
            sRequestType RT,
            tObjectSet* objects,
            char* DefaultString,
            char* param1,
            char* param2)
{
  if (HasChild(g_pHList, param2))
    return 0;
  return 1;
}



DWORD FAR _stdcall CountChildren(
            sRequestType RT,
            tObjectSet* objects,
            char* DefaultString,
            char* param1,
            char* param2)
{
  return CountChilds(g_pHList, param2);
}


DWORD FAR _stdcall CountAllChildren(
            sRequestType RT,
            tObjectSet* objects,
            char* DefaultString,
            char* param1,
            char* param2)
{
  return CountAllChilds(g_pHList, param2);
}



DWORD FAR _stdcall _MoveChildren(
            sRequestType RT,
            tObjectSet* objects,
            char* DefaultString,
            char* param1,
            char* param2)
{
  MoveChildren( g_pHList,param1, param2);
  return 0;
}


DWORD FAR _stdcall _MoveNode(
            sRequestType RT,
            tObjectSet* objects,
            char* DefaultString,
            char* param1,
            char* param2)
{
  MoveNode( g_pHList, param1, param2);
  return 0;
}



DWORD FAR _stdcall _ShowEditor(
            sRequestType RT,
            tObjectSet* objects,
            char* DefaultString,
            char* param1,
            char* param2)
{
  return 0;
}



DWORD FAR _stdcall _AffectEditing(
            sRequestType RT,
            tObjectSet* objects,
            char* DefaultString,
            char* param1,
            char* param2)
{
  return 0;
}



DWORD FAR _stdcall _UnaffectEditing(
            sRequestType RT,
            tObjectSet* objects,
            char* DefaultString,
            char* param1,
            char* param2)
{
  return 0;
}


DWORD FAR _stdcall _IsDirectChild(
            sRequestType RT,
            tObjectSet* objects,
            char* DefaultString,
            char* param1,
            char* param2)
{
  return IsDirectChild( g_pHList, param1, param2);
}


DWORD FAR _stdcall _IsIndirectChild(
            sRequestType RT,
            tObjectSet* objects,
            char* DefaultString,
            char* param1,
            char* param2)
{
  return IsIndirectChild(g_pHList, param1, param2);
}


//---------------------------------------------
// requests
//---------------------------------------------
DWORD CALLBACK SystemRequestMap(DWORD id)
{
  if (*(DWORD*)id == 0)
  {//add relation
    *(DWORD*)id = Z3D_HIERARCHY_ADDRELATION;
    return (DWORD)AddRelation;
  }
  else
  if (*(DWORD*)id == Z3D_HIERARCHY_ADDRELATION)
  {//remove relation
    *(DWORD*)id = Z3D_HIERARCHY_REMOVERELATION;
    return (DWORD)RemoveRelation;
  }
  else
  if (*(DWORD*)id == Z3D_HIERARCHY_REMOVERELATION)
  {//select unit
    *(DWORD*)id = Z3D_HIERARCHY_GETNEXTCHILD;
    return (DWORD)GetNextChild;
  }
  else
  if (*(DWORD*)id == Z3D_HIERARCHY_GETNEXTCHILD)
  {//show units (dialog box)
    *(DWORD*)id = Z3D_HIERARCHY_GETPARENT;
    return (DWORD)_GetParent;
  }
  else
  if (*(DWORD*)id == Z3D_HIERARCHY_GETPARENT)
  {//show units (dialog box)
    *(DWORD*)id = Z3D_HIERARCHY_HASCHILD;
    return (DWORD)_HasChild;
  }
  else
  if (*(DWORD*)id == Z3D_HIERARCHY_HASCHILD)
  {//show units (dialog box)
    *(DWORD*)id = Z3D_HIERARCHY_COUNTCHILDREN;
    return (DWORD)CountChildren;
  }
  else
  if (*(DWORD*)id == Z3D_HIERARCHY_COUNTCHILDREN)
  {//show units (dialog box)
    *(DWORD*)id = Z3D_HIERARCHY_COUNTALLCHILDREN;
    return (DWORD)CountAllChildren;
  }
  else
  if (*(DWORD*)id == Z3D_HIERARCHY_COUNTALLCHILDREN)
  {//show units (dialog box)
    *(DWORD*)id = Z3D_HIERARCHY_MOVECHILDREN;
    return (DWORD)_MoveChildren;
  }
  else
  if (*(DWORD*)id == Z3D_HIERARCHY_MOVECHILDREN)
  {//move child from one parent to another
    *(DWORD*)id = Z3D_HIERARCHY_MOVENODE;
    return (DWORD)_MoveNode;
  }
  else
  if (*(DWORD*)id == Z3D_HIERARCHY_MOVENODE)
  {//show units (dialog box)
    *(DWORD*)id = Z3D_HIERARCHY_SHOWEDITOR;
    return (DWORD)_ShowEditor;
  }
  else
  if (*(DWORD*)id == Z3D_HIERARCHY_SHOWEDITOR)
  {//show units (dialog box)
    *(DWORD*)id = Z3D_HIERARCHY_AFFECT_EDITING;
    return (DWORD)_AffectEditing;
  }
  else
  if (*(DWORD*)id == Z3D_HIERARCHY_AFFECT_EDITING)
  {//show units (dialog box)
    *(DWORD*)id = Z3D_HIERARCHY_UNAFFECT_EDITING;
    return (DWORD)_UnaffectEditing;
  }
  else
  if (*(DWORD*)id == Z3D_HIERARCHY_UNAFFECT_EDITING)
  {//direct child
    *(DWORD*)id = Z3D_HIERARCHY_ISDIRECTCHILD;
    return (DWORD)_IsDirectChild;
  }
  else
  if (*(DWORD*)id == Z3D_HIERARCHY_ISDIRECTCHILD)
  {//indirect child
    *(DWORD*)id = Z3D_HIERARCHY_ISINDIRECTCHILD;
    return (DWORD)_IsIndirectChild;
  }
  else
    return (DWORD)NULL;

}

